package com.example.login

import android.os.Bundle
import androidx.activity.ComponentActivity
import androidx.activity.compose.setContent
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.text.KeyboardOptions
import androidx.compose.material3.AlertDialog
import androidx.compose.material3.Button
import androidx.compose.material3.CenterAlignedTopAppBar
import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.OutlinedTextField
import androidx.compose.material3.Scaffold
import androidx.compose.material3.Surface
import androidx.compose.material3.Text
import androidx.compose.material3.TextButton
import androidx.compose.material3.TopAppBarDefaults
import androidx.compose.material3.rememberTopAppBarState
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.input.nestedscroll.nestedScroll
import androidx.compose.ui.text.input.KeyboardType
import androidx.compose.ui.text.input.PasswordVisualTransformation
import androidx.compose.ui.text.input.VisualTransformation
import androidx.compose.ui.text.style.TextOverflow
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import com.example.login.ui.theme.LoginTheme

class MainActivity : ComponentActivity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContent {
            LoginTheme {
                // A surface container using the 'background' color from the theme
                Surface(
                    modifier = Modifier.fillMaxSize(),
                    color = MaterialTheme.colorScheme.background
                ) {
//                    Moments()
                    SmallTopAppBar()
                }
            }
        }
    }
}

//@Composable
//fun Greeting() {
//    Column {
//        Text("账号")
//        Text("密码")
//    }
//}

@Composable
fun AlertDialogUpdate(
    onDismissRequest: () -> Unit,
    onConfirmation: () -> Unit,
    dialogTitle: String,
    dialogText: String,
) {
    AlertDialog(
        title = {
            Text(text = dialogTitle)
        },
        text = {
            Text(text = dialogText)
        },
        onDismissRequest = {
            onDismissRequest()
        },
        confirmButton = {
            TextButton(
                onClick = {
                    onConfirmation()
                }
            ) {
                Text("更新")
            }
        },
        dismissButton = {
            TextButton(
                onClick = {
                    onDismissRequest()
                }
            ) {
                Text("不")
            }
        }
    )
}

@Composable
fun SimpleOutlinedTextField(txt: String, type: VisualTransformation, kbt: KeyboardOptions) {
    var text by remember { mutableStateOf("") }
    Row(verticalAlignment = Alignment.CenterVertically) {
//        Text(
//            text = txt + "：".trimIndent(),
//        )

        OutlinedTextField(
            value = text,
            onValueChange = { text = it },
            label = { Text(txt) },
            visualTransformation = type,
            keyboardOptions = kbt
        )
    }
}

@OptIn(ExperimentalMaterial3Api::class)
@Composable
fun SmallTopAppBar() {
    val scrollBehavior = TopAppBarDefaults.pinnedScrollBehavior(rememberTopAppBarState())
    val showDialog = remember {
        mutableStateOf(false)
    }
    val login = remember {
        mutableStateOf(false)
    }
    val editing = remember {
        mutableStateOf(false)
    }
    val logic = remember {
        mutableStateOf(false)
    }
    if (showDialog.value) {
        AlertDialogUpdate(
            onDismissRequest = {
                showDialog.value = false
                login.value = true
                               },
            onConfirmation = {
                showDialog.value = false
                login.value = true
                             },
            dialogTitle = "更新——v114.514",
            dialogText = "修复了使用过于流畅的 Bug\n要取消更新吗？"
        )
    }
    if (login.value) {
        Moments(
            onDismissRequest = {
                login.value = false
            },
            onConfirmation = {
                login.value = false
                editing.value = true
            }
        )
    }
    else if (editing.value) {
        MomentsEditor(
            onConfirmation = {
                editing.value = false
                logic.value = true
            },
            onDismissRequest = {
                editing.value = false
                login.value = true
            }
        )
    }
    else if (logic.value) {
        Logic(
            onDismissRequest = {
                logic.value = false
                editing.value = true
            }
        )
    }
    else {
        Scaffold(
            modifier = Modifier.nestedScroll(scrollBehavior.nestedScrollConnection),
            topBar = {
                CenterAlignedTopAppBar(
                    colors = TopAppBarDefaults.topAppBarColors(
                        containerColor = MaterialTheme.colorScheme.primaryContainer,
                        titleContentColor = MaterialTheme.colorScheme.primary,
                    ),
                    title = {
                        Text(
                            "登录微信",
                            maxLines = 1,
                            overflow = TextOverflow.Ellipsis
                        )
                    },
                    scrollBehavior = scrollBehavior,
                )
            },
            content = { innerPadding ->
                Column(
                    modifier = Modifier
                        .padding(innerPadding),
                    horizontalAlignment = Alignment.CenterHorizontally,
                    verticalArrangement = Arrangement.spacedBy(16.dp),
                ) {
                    Text(text = "")
                    SimpleOutlinedTextField(
                        "账号",
                        VisualTransformation.None,
                        KeyboardOptions(keyboardType = KeyboardType.NumberPassword)
                    )
                    SimpleOutlinedTextField(
                        "密码",
                        PasswordVisualTransformation(),
                        KeyboardOptions(keyboardType = KeyboardType.Password)
                    )
                    Text(text = "")
                    Button(
                        onClick = { showDialog.value = true },
                        modifier = Modifier.fillMaxWidth()
                    ) {
                        Text("登录 / 注册")
                    }
                }
            }
        )
    }
}

@Preview(showBackground = true)
@Composable
fun GreetingPreview() {
    LoginTheme {
//        Moments()
        SmallTopAppBar()
//        Greeting()
    }
}