package com.example.login

import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.foundation.rememberScrollState
import androidx.compose.foundation.verticalScroll
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.filled.AccountBox
import androidx.compose.material.icons.filled.ArrowBack
import androidx.compose.material.icons.filled.Create
import androidx.compose.material.icons.filled.List
import androidx.compose.material3.Card
import androidx.compose.material3.CenterAlignedTopAppBar
import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.Icon
import androidx.compose.material3.IconButton
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Scaffold
import androidx.compose.material3.Text
import androidx.compose.material3.TopAppBarDefaults
import androidx.compose.material3.rememberTopAppBarState
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.input.nestedscroll.nestedScroll
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.text.style.TextOverflow
import androidx.compose.ui.unit.dp
import androidx.compose.ui.unit.sp

@Composable
fun CardMinimal(image: ImageVector, name: String, lastSeenOnline: String, contents: String) {
    Card(modifier = Modifier.fillMaxWidth()) {
        Row(verticalAlignment = Alignment.CenterVertically) {
//            Image(bitmap = image, contentDescription = "Artist image")
            Icon(
                imageVector = image,
                contentDescription = "Localized description",
                modifier = Modifier
                    .size(48.dp)
                    .align(Alignment.Top)
            )
            Column {
                Text(name, fontSize = 16.sp, fontWeight = FontWeight.Bold, color = Color.Blue)
                Text(contents)
                Text("", fontSize = 4.sp)
                Row {
                    Text(lastSeenOnline, fontSize = 12.sp)
                    Spacer(modifier = Modifier.weight(1f))
                    Icon(
                        imageVector = Icons.Filled.List,
                        contentDescription = "Localized description",
                        modifier = Modifier
                            .size(18.dp)
                    )
                    Text("\t")
                }
            }
        }
    }
}

@OptIn(ExperimentalMaterial3Api::class)
@Composable
fun Moments(onDismissRequest: () -> Unit, onConfirmation: () -> Unit) {
    val scrollBehavior = TopAppBarDefaults.pinnedScrollBehavior(rememberTopAppBarState())
    Scaffold(
        modifier = Modifier.nestedScroll(scrollBehavior.nestedScrollConnection),
        topBar = {
            CenterAlignedTopAppBar(
                colors = TopAppBarDefaults.topAppBarColors(
                    containerColor = MaterialTheme.colorScheme.primaryContainer,
                    titleContentColor = MaterialTheme.colorScheme.primary,
                ),
                title = {
                    Text(
                        "朋友圈",
                        maxLines = 1,
                        overflow = TextOverflow.Ellipsis
                    )
                },
                navigationIcon = {
                    IconButton(onClick = { onDismissRequest() }) {
                        Icon(
                            imageVector = Icons.Filled.ArrowBack,
                            contentDescription = "Localized description"
                        )
                    }
                },
                actions = {
                    IconButton(onClick = { onConfirmation() }) {
                        Icon(
                            imageVector = Icons.Filled.Create,
                            contentDescription = "Localized description"
                        )
                    }
                },
                scrollBehavior = scrollBehavior,
            )
        },
        content = { innerPadding ->
            Column(
                modifier = Modifier
                    .padding(innerPadding),
                horizontalAlignment = Alignment.CenterHorizontally,
                verticalArrangement = Arrangement.spacedBy(16.dp),
            ) {
                Column(
                    Modifier
                        .verticalScroll(rememberScrollState())
                        .padding(8.dp),
                    Arrangement.spacedBy(8.dp)
                ) {
                    CardMinimal(
                        image = Icons.Filled.AccountBox,
                        name = "お讉莣諾戀ぁ",
                        lastSeenOnline = "1分钟前",
                        contents = "道歉不一定是我错了，只是我认为这段关系比我的尊严重要。"
                    )
                    CardMinimal(
                        image = Icons.Filled.AccountBox,
                        name = "頖縌οメ葬花魂",
                        lastSeenOnline = "1小时前",
                        contents = "一开始的时候，总觉得来日方长，什么都有机会，殊不知人生是减法，见一面少一面，来日不方长。"
                    )
                    CardMinimal(
                        image = Icons.Filled.AccountBox,
                        name = "噯nǐ↘3鈖種",
                        lastSeenOnline = "4小时前",
                        contents = "成年人最体面的告别方式大概就是，我的最后一条消息你没有回，而我也默契的，没有再发，从此，我们互为过客。"
                    )
                    CardMinimal(
                        image = Icons.Filled.AccountBox,
                        name = "ㄟщμ夜倾訴患者ㄟ",
                        lastSeenOnline = "5小时前",
                        contents = "没有很快乐，也没有不快乐，好像不该这样，但也只能这样，成长也许如此，行于崩溃边缘又慢慢自愈。"
                    )
                    CardMinimal(
                        image = Icons.Filled.AccountBox,
                        name = "ギ把噯á墜落ぎ",
                        lastSeenOnline = "昨天",
                        contents = "思念大概是，每一个眉眼像你，衣着像你的人，都会忍不住多看几眼，而我知，永远不会再见你。"
                    )
                    CardMinimal(
                        image = Icons.Filled.AccountBox,
                        name = "フ默讀忧傷う",
                        lastSeenOnline = "4天前",
                        contents = "许多念念不忘只是一瞬间，许多一瞬间却是念念不忘。"
                    )
                }
            }
        }
    )
}