package com.example.login

import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.foundation.rememberScrollState
import androidx.compose.foundation.verticalScroll
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.filled.AccountCircle
import androidx.compose.material3.Button
import androidx.compose.material3.Card
import androidx.compose.material3.CenterAlignedTopAppBar
import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.Icon
import androidx.compose.material3.OutlinedButton
import androidx.compose.material3.Scaffold
import androidx.compose.material3.Text
import androidx.compose.material3.TopAppBarDefaults
import androidx.compose.material3.rememberTopAppBarState
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.input.nestedscroll.nestedScroll
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.text.style.TextOverflow
import androidx.compose.ui.unit.dp

@OptIn(ExperimentalMaterial3Api::class)
@Composable
fun Game_auth(onDismissRequest: () -> Unit, onConfirmation: () -> Unit) {
    val scrollBehavior = TopAppBarDefaults.pinnedScrollBehavior(rememberTopAppBarState())
    Scaffold(
        modifier = Modifier.nestedScroll(scrollBehavior.nestedScrollConnection),
        topBar = {
            CenterAlignedTopAppBar(
                title = {
                    Text(
                        "飞机大战授权界面",
                        maxLines = 1,
                        overflow = TextOverflow.Ellipsis
                    )
                },
                scrollBehavior = scrollBehavior,
            )
        },
        content = { innerPadding ->
            Column(
                modifier = Modifier
                    .padding(innerPadding),
                horizontalAlignment = Alignment.CenterHorizontally,
                verticalArrangement = Arrangement.spacedBy(16.dp),
            ) {
                Column(
                    Modifier
                        .verticalScroll(rememberScrollState())
                        .padding(8.dp),
                    Arrangement.spacedBy(8.dp)
                ) {
                    Card(modifier = Modifier.fillMaxWidth()) {
                        Row(verticalAlignment = Alignment.CenterVertically) {
                            Spacer(modifier = Modifier.weight(1f))
                            Icon(
                                imageVector = Icons.Filled.AccountCircle,
                                contentDescription = "Localized description",
                                modifier = Modifier.size(128.dp)
                            )
                            Text(
                                text = "\t→\t",
                            )
                            Icon(
                                imageVector = Icons.Filled.AccountCircle,
                                contentDescription = "Localized description",
                                modifier = Modifier.size(128.dp)
                            )
                            Spacer(modifier = Modifier.weight(1f))
                        }
                        Row(modifier = Modifier.padding(16.dp)) {
                            Spacer(modifier = Modifier.weight(1f))
                            Text("王小美")
                            Spacer(modifier = Modifier.weight(1f))
                            Text("全民飞机大战")
                            Spacer(modifier = Modifier.weight(1f))
                        }
                    }
                    Card(modifier = Modifier.fillMaxWidth()) {
                        Column(modifier = Modifier.padding(8.dp)) {
                            Text("登录后该应用将获得以下权限", fontWeight = FontWeight.Bold)
                            Option(lbl = "获取你的公开信息（昵称、头像等）")
                            Option(lbl = "寻找与你共同使用该应用的好友")
                            Option(lbl = "帮助你通过该应用向好友发送消息")
                        }
                    }
                    Button(
                        onClick = { onConfirmation() },
                        modifier = Modifier.fillMaxWidth()
                    ) {
                        Text("确认登录")
                    }
                    OutlinedButton(
                        onClick = { onDismissRequest() },
                        modifier = Modifier.fillMaxWidth()
                    ) {
                        Text("取消")
                    }
                }
            }
        }
    )
}