#include <cstdarg>
#include <cstdint>
#include <cstdlib>
#include <ostream>
#include <new>

struct CvMat;

struct UdpReader;

struct Frame {
  const uint8_t *data;
  int32_t cols;
  int32_t rows;
};

extern "C" {

CvMat *new_cam();

Frame get_frame(CvMat *ptr);

void del_cam(CvMat *ptr);

UdpReader *udp_reader();

Frame udp_frame(UdpReader *ptr);

void del_udp(UdpReader *ptr);

void send_video();

void over();

bool is_sending();

} // extern "C"
